function [Dunit,Mhits]=Data_output(sMap,sD)

% Return two outputs

% For Dunit, 1st column:           Original order of input data;
%            2nd column:           Best Matching Unit belonging to;
%            3rd to last columns:  Original input data.

% For Mhits, 1st column:           Neuron ID;
%            2nd column:           Hit histogram;
%            3rd to last columns:  Codebook matrix.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Divide input original data sD according to sMap
%% vneurons: data vectors hitting the specified neurons
%% ind: corresponding data row indexes
[vneurons,ind]=som_divide(sMap,sD);

% Obtain Dunit
output_unit=[];
for j=1:length(ind)
    tmp_unit=repmat(j,size(ind{j},1),1);
    output_unit=[output_unit;tmp_unit];
end
output_index=cell2mat(ind);
output_data=cell2mat(vneurons);
Dunit=[output_index output_unit output_data];
Dunit=sortrows(Dunit,1);

% Obtain Mhits
Mhits=zeros(size(sMap.codebook,1),size(sMap.codebook,2)+2);
for j=1:length(ind)
    Mhits(j,1)=j;
    Mhits(j,2)=size(ind{j},1);
end
Mhits(:,3:end)=sMap.codebook;

return
